@echo off
setlocal EnableExtensions EnableDelayedExpansion

REM ===============================
REM Konfiguration
REM ===============================
set "FFMPEG=ffmpeg"
set "FFPROBE=ffprobe"
set "OUTDIR=stereo_out"

if not exist "%OUTDIR%" mkdir "%OUTDIR%"

echo(
echo =========================================
echo 5.1 und 5.1_side zu Stereo Downmix (WAV)
echo =========================================

for %%F in (*.aac *.ac3) do (
    echo(
    echo Datei: %%F

    REM ---------- Channel Layout ermitteln ----------
    set "LAYOUT="

    "%FFPROBE%" -v error -select_streams a:0 ^
      -show_entries stream=channel_layout ^
      -of default=nw=1:nk=1 "%%F" > "%TEMP%\layout.txt"

    set /p LAYOUT=<"%TEMP%\layout.txt"
    del "%TEMP%\layout.txt" >nul 2>&1

    if not defined LAYOUT (
        echo WARNUNG: Kein Channel-Layout erkannt
        goto :next
    )

    echo Layout erkannt: !LAYOUT!

    REM ---------- 5.1 (rear) ----------
    if /I "!LAYOUT!"=="5.1" (
        echo Downmix: 5.1 (rear)

        "%FFMPEG%" -y -i "%%F" ^
        -filter_complex ^
        "pan=stereo|FL=FL+0.707*FC-0.5*BL-0.5*BR|FR=FR+0.707*FC-0.5*BL-0.5*BR,alimiter=limit=0.97" ^
        -c:a pcm_s16le ^
        "%OUTDIR%\%%~nF.wav"
    )

    REM ---------- 5.1 (side) ----------
    if /I "!LAYOUT!"=="5.1(side)" (
        echo Downmix: 5.1 (side)

        "%FFMPEG%" -y -i "%%F" ^
        -filter_complex ^
        "pan=stereo|FL=FL+0.707*FC-0.5*SL-0.5*SR|FR=FR+0.707*FC-0.5*SL-0.5*SR,alimiter=limit=0.97" ^
        -c:a pcm_s16le ^
        "%OUTDIR%\%%~nF.wav"
    )

    :next
)

echo(
echo Fertig.
pause
